setwd("C:/Rdata")

ERROR.SLEEP.TIME <- 10

data_read <- read.csv("Scenarios.csv")

for (i in 1:30) {

  cat(paste("Simulation",i,"running","...\r\n"))
  filename <- paste("Scen",i,".csv",sep="")

  Scenario <- c(1,1)
  Run <- c("Yes","Yes")
  Name <- c("Base","Base")
  Asset_Type <- c("Existing","New")
  Demand_Growth <- c(data_read$Demand.growth[i],data_read$Demand.growth[i]) 
  Elasticity <- c(data_read$Existing.elasticity[i],data_read$New.elasticity[i]) 
  Demand <- c(1758153,1758153*data_read$New.demand[i])
  Current_Retail_Price <- c(85,85) #
  Current_Input_Price <- c(38.39,38.39)
  Depreciation <- c(data_read$Depreciation[i],data_read$Depreciation[i])
  Regulation_Length <- c(5,5) 
  Mean <- c(0.0724,0.0724) 
  Standard_Dev <- c(0.0111,0.0111) 
  VC <- Current_Input_Price*data_read$Percentage.VC[i]
  FC <- (Current_Input_Price-VC)/(Mean+Depreciation)
  
  
  Demand_Curve <- c(toString(data_read$Demand.curve[i]), toString(data_read$Demand.curve[i]))
  Surplus <- c(toString(data_read$Surplus[i]),toString(data_read$Surplus[i]))
  if (data_read$Demand.curve[i]=="Linear") {
    PMax <- -Current_Retail_Price/Elasticity+ Current_Retail_Price 
  }else if (data_read$Demand.curve[i]=="Isoelastic") {
    PMax <- c(data_read$WTP[i],data_read$WTP[i]) 
  } else {
    stop('Demand curve not defined!')
  }
  
  column_names <- c("Scenario","Demand_Curve", "Run","Name","Asset_Type","VC", "FC", "Demand_Growth","Elasticity",
                 "Demand","Current_Retail_Price", "PMax","Depreciation",
                 "Regulation_Length","Mean","Standard.Dev.","Surplus")
  
  
  input <- data.frame(Scenario,Demand_Curve,Run,Name,Asset_Type,VC, FC, Demand_Growth,Elasticity,
                      Demand,Current_Retail_Price, PMax, Depreciation,
                      Regulation_Length,Mean,Standard_Dev,Surplus,
                      check.rows = TRUE,check.names = TRUE,
                      stringsAsFactors = FALSE)
  
  names(input) <- column_names
  
  source("loss_modeling.R")
  
  result <- run(input)
  write.csv(result,filename)
  
}
  
  